package main

import (
	"fmt"
	"strings"
	"unicode/utf8"
)

func printHeader() {
	// ╗ -187 ╝ - 188 ╚ - 200 ╔ - 201 ╟ - 199 ╢ - 182 ═ - 205 ─ -196
	st := fmt.Sprintf("Задача:")
	n := utf8.RuneCountInString(st)
	stl := []string{
		"Поиск счастливых билетов",
		"2018 - Stelletskiy V.",
		"Версия 1.0",
	}
	for _, s := range stl {
		if utf8.RuneCountInString(s) > n {
			n = utf8.RuneCountInString(s)
		}
	}

	fmt.Println("╔" + strings.Repeat("═", n+2) + "╗")
	for _, s := range stl {
		fmt.Println("║ " + s + strings.Repeat(" ", n-utf8.RuneCountInString(s)) + " ║")
	}
	fmt.Println("╟" + strings.Repeat("─", n+2) + "╢")
	fmt.Println("║ " + st + strings.Repeat(" ", n-utf8.RuneCountInString(st)) + " ║")
	fmt.Println("╚" + strings.Repeat("═", n+2) + "╝")
	fmt.Println("")
}
