unit f_About;

interface

uses
  Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ShellAPI, ComCtrls, jpeg;

type
  TAboutBox = class(TForm)
    lbProductName: TLabel;
    lbVersion: TLabel;
    lbAutor: TLabel;
    Timer1: TTimer;
    lbDate: TLabel;
    Image1: TImage;
    lbEMail: TLabel;
    lbHttp: TLabel;
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Timer1Timer(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure lbHttpClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
  private
    procedure OpenLink(aText:string);
  end;

var
  AboutBox: TAboutBox;

implementation

{$R *.DFM}

var st:string;

procedure TAboutBox.OpenLink(aText:string);
var st:string;
begin
  if Pos('@',aText)>1 then st:='mailto:';
  ShellExecute(handle,'open',PChar(st+aText),nil,nil,SW_SHOW);
end;

procedure TAboutBox.FormClick(Sender: TObject);
begin
  Close;
end;

procedure TAboutBox.FormKeyPress(Sender: TObject; var Key: Char);
var st1:string;
begin
  if Key=#27 then Close;
  if Length(st)>20 then Delete(st,1,10);
  st:=st+Key;
  st1:=AnsiUpperCase(st);
  if (Pos('SVV',st1)>0) or (Pos('',st1)>0) then
  begin
   if fsBold in lbAutor.Font.Style then
    lbAutor.Font.Style:=lbAutor.Font.Style-[fsBold]
   else
    begin
     Application.ProcessMessages;
     lbAutor.Font.Style:=lbAutor.Font.Style+[fsBold];
    end;
   MessageBeep(1);
   st:='';
  end;
  if (Pos('',st1)>0) or (Pos('CGFCB,J',st1)>0) or
     (Pos('THANKS',st1)>0) or (Pos('',st1)>0) then
  begin
   Timer1.Enabled:=not Timer1.Enabled;
   if Timer1.Enabled then
    begin
     Application.ProcessMessages;
    end
   else
    begin
     lbAutor.Font.Color:=clWindowText;
     lbAutor.Visible:=true;
    end;
   MessageBeep(1);
   st:='';
  end;
end;

procedure TAboutBox.Timer1Timer(Sender: TObject);
var col:TColor;
begin
 lbAutor.Visible:=not lbAutor.Visible;
 Timer1.Tag:=Timer1.Tag+1;
 col:=lbAutor.Font.Color;
 case Timer1.Tag of
  6: begin col:=clRed; end;
  12: begin col:=clYellow; end;
  18: begin col:=clLime; end;
  24: begin col:=clBlue; end;
  30: begin col:=clFuchsia; end;
  36:begin
      Timer1.Tag:=0;
      col:=clWindowText;
     end;
 end;
 if col<>lbAutor.Font.Color then
  lbAutor.Font.Color:=col;
end;

procedure TAboutBox.FormHide(Sender: TObject);
begin
 Timer1.Enabled:=false;
 lbAutor.Font.Color:=clWindowText;
 if fsBold in lbAutor.Font.Style then
  lbAutor.Font.Style:=lbAutor.Font.Style-[fsBold];
 lbAutor.Visible:=true;
end;

procedure TAboutBox.lbHttpClick(Sender: TObject);
begin
  OpenLink((Sender as TLabel).Caption)
end;

procedure TAboutBox.FormPaint(Sender: TObject);
begin
 Canvas.Pen.Width:=1;
 Canvas.Pen.Color:=clWhite;
 Canvas.Rectangle(0,0,ClientWidth,ClientHeight);
 Canvas.Pen.Color:=clBlack;
 Canvas.Rectangle(1,1,ClientWidth-1,ClientHeight-1);
end;

end.

