package main

import (
	"fmt"
	"math/rand"
	"strings"
	"time"
	"unicode/utf8"
)

const total = 50

type Answers = struct {
	current   int
	score     int
	correct   int
	errors    int
	totalTime int
}

func getRandInt(randInt chan int) {
	rand.Seed(time.Now().UnixNano())
	var zero, one, ten bool
	for {
		n := rand.Intn(11)
		// числа 0, 1 и 10 должны встречаться не более 1 раза
		if (zero && n == 0) || (one && n == 1) || (ten && n == 10) {
			continue
		}
		switch n {
		case 0:
			zero = true
		case 1:
			one = true
		case 10:
			ten = true
		}
		randInt <- n
	}
}

func printHeader() {
	// ╗ -187 ╝ - 188 ╚ - 200 ╔ - 201 ╟ - 199 ╢ - 182 ═ - 205 ─ -196
	st := fmt.Sprintf("Задача - решать предложенные примеры и набрать %d баллов", total)
	n := utf8.RuneCountInString(st)
	stl := []string{
		"Проверка знания таблицы умножения",
		"2017 - Stelletskiy V.V.",
		"Версия 1.0",
	}
	fmt.Println("╔" + strings.Repeat("═", n+2) + "╗")
	for _, s := range stl {
		fmt.Println("║ " + s + strings.Repeat(" ", n-utf8.RuneCountInString(s)) + " ║")
	}
	fmt.Println("╟" + strings.Repeat("─", n+2) + "╢")
	fmt.Println("║ " + st + " ║")
	fmt.Println("╚" + strings.Repeat("═", n+2) + "╝")
	fmt.Println("")
}

func main() {
	randInt := make(chan int)
	go getRandInt(randInt)
	printHeader()
	fmt.Println("Начинаем?\nНажмите Enter для продолжения или Ctrl+C для выхода")
	st := ""
	fmt.Scanln(&st)
	a := Answers{}
	a.current = 1
	for {
		x := <-randInt
		y := <-randInt
		z := 0
		fmt.Printf("\n%d. %d x %d = ", a.current, x, y)
		start := time.Now()
		fmt.Scanf("%s\n", &st)
		fmt.Sscanf(st, "%d", &z)
		//		t := time.Now()
		//		elapsed := t.Sub(start)
		elapsed := int(time.Since(start) / time.Millisecond)
		a.totalTime += elapsed
		if x*y == z {
			a.correct++
			switch {
			case elapsed < 2000:
				st = "Восхитительно"
				a.score += 5
			case elapsed < 3000:
				st = "Отлично"
				a.score += 3
			case elapsed < 5000:
				st = "Хорошо"
				a.score += 2
			default:
				st = "Верно"
				a.score++
			}
			fmt.Printf(st)
			// fmt.Printf(st+", %d", elapsed)
		} else {
			fmt.Printf("!!! - неправильно (%d x %d = %d)", x, y, x*y)
			a.score -= 10
			a.errors++
		}
		if a.score >= total {
			fmt.Printf("\n\nУра!!! Вы выиграли!")
			fmt.Printf("\nВсего было задано вопросов: %d", a.current)
			if a.errors > 0 {
				fmt.Printf("\nНеправильных ответов: %d", a.errors)
			}
			fmt.Printf("\nОбщее время: %.1f сек., среднее %.2f сек.", float64(a.totalTime)/1000, float64(a.totalTime/a.current)/1000)
			break
		}
		a.current++
	}
	fmt.Println("\n\nНажмите Enter для для выхода")
	st = ""
	fmt.Scanln(&st)
}
